/*
 * Decompiled with CFR 0.152.
 */
package net.sf.wmutils.is.packages.streams;

import com.wm.app.b2b.server.ContentHandler;
import com.wm.app.b2b.server.ContentHandler_SOAP;
import com.wm.app.b2b.server.ContentHandler_XML;
import com.wm.app.b2b.server.InvokeState;
import com.wm.app.b2b.server.ServerAPI;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSService;
import com.wm.util.Values;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.wmutils.is.packages.streams.AbstractContentHandler;
import net.sf.wmutils.is.packages.streams.StreamingContentHandler;
import net.sf.wmutils.is.packages.streams.StreamingContentHandlerFactory;
import net.sf.wmutils.is.packages.streams.Utils;
import net.sf.wmutils.is.packages.streams.ValueLogger;
import org.apache.log4j.Logger;

public class DefaultContentHandler
extends AbstractContentHandler {
    private static final Logger log = Logger.getLogger(DefaultContentHandler.class);
    private ContentHandler handler;

    public DefaultContentHandler(StreamingContentHandlerFactory pFactory) {
        super(pFactory);
    }

    private String getServiceName(NSService pService) {
        NSName name;
        if (pService != null && (name = pService.getNSName()) != null) {
            return name.getFullName();
        }
        return "Unknown service";
    }

    private ContentHandler getContentHandler(InvokeState pState) {
        int protocolId;
        NSService service = null;
        if (pState == null) {
            protocolId = 1;
        } else {
            NSName specName;
            service = pState.getService();
            if (service != null && (specName = service.getSpecification()) != null && "net.sf.wmutils.streams:StreamingService".equals(specName.getFullName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delegating to streaming service " + this.getServiceName(service)));
                }
                return new StreamingContentHandler(this.getFactory());
            }
            protocolId = pState.getProtocolID();
        }
        switch (protocolId) {
            case 3: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delegating to service " + this.getServiceName(service) + " via SOAP handler."));
                }
                return new ContentHandler_SOAP(this.getContentType());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delegating to service " + this.getServiceName(service) + " via XML handler."));
        }
        return new ContentHandler_XML();
    }

    public Values getInputValues(InputStream pStream, InvokeState pState) throws IOException {
        log.debug((Object)"getInputValues: ->");
        try {
            this.handler = this.getContentHandler(pState);
            Values values = this.handler.getInputValues(pStream, pState);
            ValueLogger.log(log, values, log.isTraceEnabled() || Utils.isTracing());
            log.debug((Object)"getInputValues: <-");
            return values;
        }
        catch (RuntimeException e) {
            ServerAPI.logError((Throwable)e);
            log.error((Object)e);
            return this.asValues(e);
        }
        catch (Error e) {
            ServerAPI.logError((Throwable)e);
            log.error((Object)e);
            return this.asValues(e);
        }
        catch (IOException e) {
            ServerAPI.logError((Throwable)e);
            log.error((Object)e);
            return this.asValues(e);
        }
    }

    private Values asValues(Throwable pThrowable) {
        this.handler = new StreamingContentHandler(this.getFactory());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pThrowable.printStackTrace(pw);
        pw.close();
        Values values = new Values();
        values.put("inputStream", (Object)("<soap:Envelope xmlns='http://schemas.xmlsoap.org/soap/envelope/'><soap:Fault>" + sw.toString() + "</soap:Fault></soap:Envelope>"));
        return values;
    }

    public String getContentType() {
        if (this.handler == null) {
            return super.getContentType();
        }
        return this.handler.getContentType();
    }

    public void putOutputValues(OutputStream pStream, Values pValues, InvokeState pState) throws IOException {
        log.debug((Object)("putOutputValues: -> " + (this.handler == null ? null : this.handler.getClass().getName())));
        ValueLogger.log(log, pValues, log.isTraceEnabled() || Utils.isTracing());
        if (this.handler != null) {
            try {
                this.handler.putOutputValues(pStream, pValues, pState);
            }
            catch (RuntimeException e) {
                ServerAPI.logError((Throwable)e);
                log.error((Object)e);
                throw e;
            }
            catch (Error e) {
                ServerAPI.logError((Throwable)e);
                log.error((Object)e);
                throw e;
            }
            catch (IOException e) {
                ServerAPI.logError((Throwable)e);
                log.error((Object)e);
                throw e;
            }
        }
        log.debug((Object)"putOutputValues: <-");
    }
}

