/*
 * Decompiled with CFR 0.152.
 */
package net.sf.wmutils.is.packages.streams;

import com.wm.app.b2b.server.InvokeState;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.util.Values;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import net.sf.wmutils.is.packages.streams.AbstractContentHandler;
import net.sf.wmutils.is.packages.streams.StreamingContentHandlerFactory;
import net.sf.wmutils.is.packages.streams.StreamingHandler;
import net.sf.wmutils.is.packages.streams.Utils;
import net.sf.wmutils.is.packages.streams.Writer;
import org.apache.log4j.Logger;

public class StreamingContentHandler
extends AbstractContentHandler {
    private static final Logger log = Logger.getLogger(StreamingContentHandler.class);

    public StreamingContentHandler(StreamingContentHandlerFactory pFactory) {
        super(pFactory);
    }

    public Values getInputValues(InputStream pStream, final InvokeState pState) throws IOException {
        log.debug((Object)"getInputValues: ->");
        Values values = new Values();
        Values input = new Values();
        values.put("input", (Object)input);
        StreamingHandler sh = new StreamingHandler(){

            public String getContentType() {
                return StreamingContentHandler.this.getContentType();
            }

            public void setContentType(String pContentType) {
                StreamingContentHandler.this.setContentType(pContentType);
            }

            public String getSOAPAction() {
                return Utils.getSOAPAction(pState);
            }
        };
        input.put("contentType", (Object)this.getContentType());
        input.put("inputStream", (Object)pStream);
        input.put("streamingHandler", (Object)sh);
        log.debug((Object)"getInputValues: <-");
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putOutputValues(OutputStream pOutStream, InputStream pInStream) throws IOException {
        InputStream istream = pInStream;
        try {
            int res;
            byte[] buffer = new byte[8192];
            while ((res = istream.read(buffer)) != -1) {
                if (res <= 0) continue;
                pOutStream.write(buffer, 0, res);
            }
            istream.close();
            istream = null;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putOutputValues(OutputStream pOutStream, Writer pWriter) throws IOException {
        Writer writer = pWriter;
        try {
            writer.writeTo(pOutStream);
            writer.close();
            writer = null;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void putOutputValues(OutputStream pOutStream, Source pSource, Transformer pTransformer) throws IOException {
        try {
            Transformer t = pTransformer == null ? TransformerFactory.newInstance().newTransformer() : pTransformer;
            t.transform(pSource, new StreamResult(pOutStream));
        }
        catch (TransformerException e) {
            log.error((Object)e);
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (RuntimeException e) {
            log.error((Object)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)e);
            throw e;
        }
    }

    protected void setStatusCode(InvokeState pState, IDataCursor pCursor) {
        int statusCode;
        Object httpStatusCode = IDataUtil.get((IDataCursor)pCursor, (String)"httpStatusCode");
        if (httpStatusCode == null) {
            return;
        }
        if (httpStatusCode instanceof Integer) {
            statusCode = (Integer)httpStatusCode;
        } else if (httpStatusCode instanceof String) {
            try {
                statusCode = Integer.parseInt((String)httpStatusCode);
            }
            catch (Exception e) {
                log.error((Object)("setStatusCode: Invalid HTTP status code: " + httpStatusCode));
                return;
            }
        } else {
            log.error((Object)("setStatusCode: Invalid HTTP status code: " + httpStatusCode));
            return;
        }
        String httpStatusMessage = (String)IDataUtil.get((IDataCursor)pCursor, (String)"httpStatusMessage");
        Utils.setHttpResponseCode(pState, statusCode, httpStatusMessage);
    }

    public void putOutputValues(OutputStream pStream, Values pValues, InvokeState pState) throws IOException {
        IData iData = (IData)pValues.get("output");
        if (iData == null) {
            String reply = "<error>Service returned no reply</error>";
            pStream.write("<error>Service returned no reply</error>".getBytes("UTF-8"));
            return;
        }
        IDataCursor iDataCursor = iData.getCursor();
        InputStream istream = (InputStream)IDataUtil.get((IDataCursor)iDataCursor, (String)"inputStream");
        if (istream == null) {
            Writer writer = (Writer)IDataUtil.get((IDataCursor)iDataCursor, (String)"writer");
            if (writer == null) {
                Source source = (Source)IDataUtil.get((IDataCursor)iDataCursor, (String)"source");
                if (source == null) {
                    String reply = "<error>Service reply contained no output data.</error>";
                    pStream.write("<error>Service reply contained no output data.</error>".getBytes("UTF-8"));
                } else {
                    Transformer t = (Transformer)IDataUtil.get((IDataCursor)iDataCursor, (String)"transformer");
                    this.putOutputValues(pStream, source, t);
                }
            } else {
                this.putOutputValues(pStream, writer);
            }
        } else {
            this.putOutputValues(pStream, istream);
        }
    }
}

