package net.sf.wmutils.issync;


/**
 * Instances of this class are used to specify IS packages.
 */
public class Package {
	private String name;
	private boolean usingDefaultExcludes = true;

	/**
	 * Returns the array of included files.
	 */
	public String[] getIncludes() {
		return includes;
	}

	/**
	 * Sets the array of included files.
	 */
	public void setIncludes(String[] pIncludes) {
		includes = pIncludes;
	}

	/**
	 * Returns the array of excluded files.
	 */
	public String[] getExcludes() {
		return excludes;
	}

	/**
	 * Sets the array of excluded files.
	 */
	public void setExcludes(String[] excludes) {
		this.excludes = excludes;
	}

	private String[] includes, excludes;

	/**
	 * Returns the package name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the package name.
	 */
	public void setName(String pName) {
		name = pName;
	}

	/**
	 * Sets, whether default excludes should be applied. This is
	 * recommended, because it prevents .svn directories being copied.
	 * Defaults to true.
	 */
	public boolean isUsingDefaultExcludes() {
		return usingDefaultExcludes;
	}

	/**
	 * Sets, whether default excludes should be applied. This is
	 * recommended, because it prevents .svn directories being copied.
	 * Defaults to true.
	 */
	public void setUsingDefaultExcludes(boolean pUsingDefaultExcludes) {
		usingDefaultExcludes = pUsingDefaultExcludes;
	}
}
