package net.sf.wmutils.issync;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;


/**
 * A Maven Mojo, which copies a local directory to an integration
 * servers package directory, overwriting the package.
 * @goal sync-from-is
 */
public class SyncFromIsMojo extends AbstractSyncMojo {
	public void execute() throws MojoExecutionException, MojoFailureException {
		final File isPackageDir = getIsPackageDir();
		final File localPackageDir = getLocalPackageDir();
		final Package[] packages = getPackages();
		for (int i = 0;  i < packages.length;  i++) {
			sync(packages[i], isPackageDir, localPackageDir);
		}
	}
}
