/*
 * Decompiled with CFR 0.152.
 */
package net.sf.wmutils.issync;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.sf.wmutils.issync.Package;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSyncMojo
extends AbstractMojo {
    private File isRoot;
    private File isPackages;
    private File localPackages;
    private Package[] packages;
    protected MavenProject project;

    protected Package[] getPackages() {
        return this.packages;
    }

    protected File getIsPackageDir() throws MojoFailureException {
        if (this.isPackages == null) {
            if (this.isRoot == null) {
                throw new MojoFailureException("Required parameter isRoot is not set.");
            }
            return new File(this.isRoot, "packages");
        }
        return this.isPackages;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getLocalPackageDir() {
        if (this.localPackages == null) {
            return new File(this.getProject().getBasedir(), "src/main/isPackages");
        }
        return this.localPackages;
    }

    private DirectoryScanner getDirectoryScanner(Package pPackage, File pDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(pDir);
        scanner.setIncludes(pPackage.getIncludes());
        scanner.setExcludes(pPackage.getExcludes());
        if (pPackage.isUsingDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        return scanner;
    }

    protected void sync(Package pPackage, File pFromDir, File pToDir) throws MojoExecutionException {
        File fromDir = new File(pFromDir, pPackage.getName());
        File toDir = new File(pToDir, pPackage.getName());
        if (!toDir.isDirectory() && !toDir.mkdir()) {
            throw new MojoExecutionException("Failed to create directory " + toDir.getPath());
        }
        DirectoryScanner fromDirScanner = this.getDirectoryScanner(pPackage, fromDir);
        DirectoryScanner toDirScanner = this.getDirectoryScanner(pPackage, toDir);
        HashSet<String> toDirFiles = new HashSet<String>();
        for (String file : toDirScanner.getIncludedFiles()) {
            toDirFiles.add(file);
        }
        for (String file : fromDirScanner.getIncludedFiles()) {
            File source = new File(fromDir, file);
            File target = new File(toDir, file);
            try {
                FileUtils.copyFile((File)source, (File)target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy file " + source + " to " + target + ": " + e.getMessage(), (Exception)e);
            }
            toDirFiles.remove(file);
        }
        for (String file : toDirFiles) {
            File target = new File(toDir, file);
            try {
                FileUtils.forceDelete((File)target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to delete file " + target + ": " + e.getMessage(), (Exception)e);
            }
        }
    }
}

